# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.unchecked_base_model import UncheckedBaseModel
from .integration_type import IntegrationType
from .mcp_approval_policy import McpApprovalPolicy


class McpToolConfigOutput(UncheckedBaseModel):
    """
    An MCP tool configuration that can be used to call MCP servers
    """

    name: str
    description: str
    response_timeout_secs: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum time in seconds to wait for the tool call to complete.
    """

    integration_type: IntegrationType = pydantic.Field()
    """
    The type of MCP tool
    """

    parameters: typing.Optional["ObjectJsonSchemaPropertyOutput"] = pydantic.Field(default=None)
    """
    Schema for any parameters the LLM needs to provide to the MCP tool.
    """

    approval_policy: typing.Optional[McpApprovalPolicy] = pydantic.Field(default=None)
    """
    The approval policy for the MCP tool
    """

    mcp_tool_name: str = pydantic.Field()
    """
    The name of the MCP tool to call
    """

    mcp_tool_description: str = pydantic.Field()
    """
    The description of the MCP tool to call
    """

    mcp_server_id: str = pydantic.Field()
    """
    The id of the MCP server to call
    """

    mcp_server_name: str = pydantic.Field()
    """
    The name of the MCP server to call
    """

    mcp_input_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Original inputSchema dict for consistent hashing (pure MCP format)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_json_schema_property_output import ArrayJsonSchemaPropertyOutput  # noqa: E402, F401, I001
from .object_json_schema_property_output import ObjectJsonSchemaPropertyOutput  # noqa: E402, F401, I001

update_forward_refs(McpToolConfigOutput)
