# 多语言支持

## 站点多语言配置

要启用 VuePress 的多语言支持，首先需要使用如下的文件目录结构：

```
docs
├─ README.md
├─ foo.md
├─ nested
│  └─ README.md
└─ zh
   ├─ README.md
   ├─ foo.md
   └─ nested
      └─ README.md
```

然后，在你的 [配置文件](./configuration.md#配置文件) 中设置 `locales` 选项：

```js
module.exports = {
  locales: {
    // 键名是该语言所属的子路径
    // 作为特例，默认语言可以使用 '/' 作为其路径。
    '/': {
      lang: 'en-US',
      title: 'VuePress',
      description: 'Vue-powered Static Site Generator',
    },
    '/zh/': {
      lang: 'zh-CN',
      title: 'VuePress',
      description: 'Vue 驱动的静态网站生成器',
    },
  },
}
```

如果一个语言没有声明 `lang`, `title`, `description` 或者 `head` ，VuePress 将会尝试使用顶层配置的对应值。如果每个语言都声明了这些值，那么顶层配置中的对应值可以被省略。

::: tip
配置参考： [locales](../reference/config.md#locales)
:::

## 主题多语言配置

VuePress 没有限制主题如何提供多语言支持，因此每个主题可能会有不同的多语言配置方式，而且部分主题可能不会提供多语言支持。建议你查看主题本身的文档来获取更详细的指引。

如果你使用的是默认主题，那么它提供多语言支持的方式和上述是一致的：

```js
module.exports = {
  themeConfig: {
    locales: {
      '/': {
        selectLanguageName: 'English',
      },
      '/zh/': {
        selectLanguageName: '简体中文',
      },
    },
  },
}
```

::: tip
配置参考： [默认主题 > locales](../reference/default-theme/config.md#locales)
:::
