---
sidebar: auto
---

# Contributing Guide

## Overview

This repository employs a [monorepo](https://en.wikipedia.org/wiki/Monorepo) setup with [yarn classic workspaces](https://classic.yarnpkg.com/en/docs/workspaces), and hosts a number of associated but separated packages in the `packages` directory:

- `@vuepress/core`: The VuePress core. Provides pure Node API to generate VuePress app, including page handling, plugin system and data preparation.

- `@vuepress/client`: The VuePress client package. Provides the client entry, and exports types and composable utils that can be used in client side development.

- `@vuepress/bundler-vite`: The VuePress bundler package with vite. Use vite to `dev` and `build` VuePress app that generated by `@vuepress/core`.

- `@vuepress/bundler-webpack`: The VuePress bundler package with webpack. Use webpack to `dev` and `build` VuePress app that generated by `@vuepress/core`.

- `@vuepress/cli`: The VuePress command line interface (CLI) package. It will resolve user config file, and create VuePress app with `@vuepress/core`, then use `@vuepress/bundler-${name}` to execute corresponding command.

- `@vuepress/theme-default`: The VuePress default theme.

- `@vuepress/plugin-${name}`: Official plugins.

- `@vuepress/shared`: Utilities that shared between node side and client side.

- `@vuepress/utils`: Utilities that should only be used in node side.

- `vuepress`: A wrapper of `vuepress-vite`.

- `vuepress-vite`: A wrapper of `@vuepress/cli` + `@vuepress/bundler-vite` + `@vuepress/theme-default`. If users want to use default theme with vite, they can simply install this package.

- `vuepress-webpack`: A wrapper of `@vuepress/cli` + `@vuepress/bundler-webpack` + `@vuepress/theme-default`. If users want to use default theme with webpack, they can simply install this package.

## Development Setup

Pre-requirement:

- [Node.js](http://nodejs.org) **version 14+**
- [Yarn v1 classic](https://classic.yarnpkg.com/en/docs/install)

Clone the repo, and install dependencies:

```bash
yarn
```

Start watching source files:

```bash
yarn dev
```

Open another terminal, and start developing the documentation site:

```bash
yarn docs:dev
```

Main tools that used in this project:

- [TypeScript](https://www.typescriptlang.org/) as the development language
- [Jest](https://jestjs.io/) for unit testing
- [ESLint](https://eslint.org/) + [Prettier](https://prettier.io/) for code linting and formatting

## Scripts

### `yarn build`

The `build` script uses `tsc` to compile typescript source files to javascript dist files.

You may need to run this script first after your clone this repository, because the dist files are ignored by `.gitignore`.

### `yarn copy`

The `copy` script of root project runs `copy` script in all packages, copying some resources from source directory to dist directory.

Some source files (e.g. `.vue`, `.css` files) can not be processed by `build` script, but should keep the same relative path in the dist directory.

You may need to run this script after your clone this repository, too.

### `yarn dev`

The `dev` script runs `copy` and `build` scripts in watch mode.

### `yarn clean`

The `clean` script runs `clean` script in all packages, cleaning all the dist files and caches. In other words, it will remove all the files that generated by `build`, `copy` and `dev` scripts.

It's used before you want to re-build source files from a clean / initial state.

### `yarn docs:*`

#### `yarn docs:build`, `yarn docs:dev`, `yarn docs:clean`

The `docs:` prefix indicates that these scripts are for documentation, i.e. the `docs` directory.

VuePress is using itself to build its own documentation site.

You need to run `yarn build && yarn copy` to build VuePress source files first, then run these `docs:` scripts to develop and build our documentation.

#### `yarn docs:serve`

Serve the documentation site locally.

You need to run `yarn docs:build` first to generate the documentation dist files, and then run `yarn docs:serve` to serve them.

### `yarn lint`

The `lint` script uses ESLint to check all source files.

### `yarn test`

The `test` script uses Jest to run unit testings.

## Documentation

VuePress documentation is powered by VuePress itself, which is built from the source code of this repository.

All the markdown source files are placed in `docs` directory. We are maintaining two translations:

- English (en-US) in `/` path
- Chinese (zh-CN) in `/zh/` path

We have two different deployments:

- Release deployment powered by [Netlify](https://www.netlify.com). This deployment is built from the latest released version, so users will not see unreleased changes. The domain name is [https://v2.vuepress.vuejs.org](https://v2.vuepress.vuejs.org).
- Developer deployment powered by [GitHub Pages](https://pages.github.com). This deployment is built from the latest commit, so developers could preview the latest changes. The domain name is [https://vuepress.github.io](https://vuepress.github.io).
