export const StatusImage = ({ ...props }) => (
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" {...props}>
    <path
      d="M2 9C2 5.13401 5.13401 2 9 2V2C12.866 2 16 5.13401 16 9V9C16 12.866 12.866 16 9 16V16C5.13401 16 2 12.866 2 9V9Z"
      fill="currentColor"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M0.5 9C0.5 4.30558 4.30558 0.5 9 0.5C13.6944 0.5 17.5 4.30558 17.5 9C17.5 13.6944 13.6944 17.5 9 17.5C4.30558 17.5 0.5 13.6944 0.5 9ZM9 3.5C5.96243 3.5 3.5 5.96243 3.5 9C3.5 12.0376 5.96243 14.5 9 14.5C12.0376 14.5 14.5 12.0376 14.5 9C14.5 5.96243 12.0376 3.5 9 3.5Z"
      fill="white"
    />
  </svg>
);

export const VerifiedImage = ({ ...props }) => (
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" {...props}>
    <path
      d="M13.5486 0.905725L13.6528 1.11381L14.439 3.20462C14.5008 3.36927 14.6307 3.49919 14.7954 3.56096L16.814 4.31829C17.6999 4.65063 18.1759 5.59722 17.9399 6.49282L17.8831 6.67107L16.9439 8.74803C16.8712 8.90813 16.8712 9.09187 16.9439 9.25197L17.8358 11.2149C18.2272 12.0763 17.8945 13.0822 17.0943 13.5486L16.8862 13.6528L14.7954 14.439C14.6307 14.5008 14.5008 14.6307 14.439 14.7954L13.6817 16.814C13.3494 17.6999 12.4028 18.1759 11.5072 17.9399L11.3289 17.8831L9.25197 16.9439C9.09187 16.8712 8.90813 16.8712 8.74803 16.9439L6.78511 17.8358C5.92372 18.2272 4.91778 17.8945 4.45141 17.0943L4.34718 16.8862L3.56096 14.7954C3.49919 14.6307 3.36927 14.5008 3.20462 14.439L1.18597 13.6817C0.300118 13.3494 -0.17591 12.4028 0.0601429 11.5072L0.116938 11.3289L1.05606 9.25197C1.12881 9.09187 1.12881 8.90813 1.05606 8.74803L0.164176 6.78511C-0.227213 5.92372 0.105523 4.91778 0.905725 4.45141L1.11381 4.34718L3.20462 3.56096C3.36927 3.49919 3.49919 3.36927 3.56096 3.20462L4.31829 1.18597C4.65063 0.300118 5.59722 -0.17591 6.49282 0.0601429L6.67107 0.116938L8.74803 1.05606C8.90813 1.12881 9.09187 1.12881 9.25197 1.05606L11.2149 0.164176C12.0763 -0.227213 13.0822 0.105523 13.5486 0.905725Z"
      fill="#1C92FF"
    />
    <path
      d="M7.60196 10.8376L11.9468 5.87208C12.1683 5.61891 12.5532 5.59326 12.8063 5.81478C13.0595 6.0363 13.0852 6.42112 12.8636 6.67429L8.09003 12.1298C7.85801 12.395 7.45007 12.4086 7.20092 12.1594L5.15509 10.1136C4.91722 9.87574 4.91722 9.49007 5.15509 9.25219C5.39296 9.01432 5.77863 9.01432 6.01651 9.25219L7.60196 10.8376Z"
      fill="white"
    />
  </svg>
);

export const CheckboxCheck = ({ ...props }) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" {...props}>
    <path
      d="M12.813 5.914L6.743 11.985L3.5 8.742L4.914 7.328L6.743 9.157L11.399 4.5L12.813 5.914Z"
      fill="currentColor"
    />
  </svg>
);

export const CheckboxIntermediate = ({ ...props }) => (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" {...props}>
    <rect x="4" y="7" width="8" height="2" fill="currentColor" />
  </svg>
);

export const TextAreaResizer = ({ ...props }) => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M4 13.0711L13.0711 4L14.4853 5.41421L5.41421 14.4853L4 13.0711Z"
      fill="currentColor"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M9 14.2426L14.2426 9L15.6569 10.4142L10.4142 15.6569L9 14.2426Z"
      fill="currentColor"
    />
  </svg>
);

export const EnterKey = ({ ...props }) => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" {...props}>
    <path
      fill="currentColor"
      d="M19.0003 13.9999L19.0004 5.00003L17.0004 5L17.0003 11.9999L6.82845 12L10.7782 8.05027L9.36396 6.63606L3 13L9.36396 19.364L10.7782 17.9498L6.8284 14L19.0003 13.9999Z"
    ></path>
  </svg>
);

export const AiSparkles = ({ ...props }) => (
  <svg
    width="18"
    height="18"
    viewBox="0 0 18 18"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fill="currentColor"
      d="M9.022 4.39C9.118 4.39 9.179 4.329 9.2 4.233C9.391 3.119 9.384 3.105 10.56 2.873C10.656 2.853 10.717 2.797 10.717 2.695C10.717 2.599 10.656 2.538 10.56 2.524C9.384 2.305 9.405 2.284 9.2 1.164C9.18 1.068 9.118 1 9.022 1C8.926 1 8.865 1.068 8.844 1.164C8.639 2.271 8.667 2.284 7.484 2.524C7.388 2.538 7.327 2.599 7.327 2.694C7.327 2.797 7.388 2.852 7.491 2.873C8.66 3.098 8.653 3.105 8.844 4.233C8.864 4.329 8.926 4.39 9.022 4.39ZM5.7 9.237C5.85 9.237 5.966 9.127 5.987 8.984C6.219 7.186 6.267 7.172 8.154 6.824C8.22258 6.81652 8.28587 6.78362 8.3314 6.7318C8.37693 6.67997 8.40141 6.61297 8.4 6.544C8.4 6.394 8.29 6.277 8.147 6.264C6.274 6.004 6.219 5.949 5.987 4.11C5.967 3.96 5.857 3.85 5.7 3.85C5.55 3.85 5.44 3.96 5.42 4.117C5.2 5.915 5.126 5.915 3.252 6.263C3.102 6.283 3 6.393 3 6.543C3 6.701 3.102 6.803 3.28 6.823C5.126 7.111 5.2 7.173 5.42 8.97C5.44 9.128 5.55 9.237 5.7 9.237ZM10.52 16.777C10.731 16.777 10.895 16.627 10.93 16.401C11.428 12.731 11.94 12.149 15.585 11.739C15.6897 11.7324 15.7881 11.6866 15.8604 11.6105C15.9328 11.5345 15.9737 11.4339 15.975 11.329C15.975 11.109 15.81 10.946 15.585 10.912C11.975 10.481 11.462 9.955 10.929 6.25C10.889 6.03 10.731 5.88 10.519 5.88C10.307 5.88 10.143 6.03 10.109 6.25C9.609 9.927 9.097 10.508 5.454 10.912C5.228 10.939 5.064 11.11 5.064 11.329C5.064 11.541 5.228 11.712 5.454 11.739C9.056 12.231 9.555 12.703 10.109 16.401C10.149 16.627 10.308 16.777 10.52 16.777Z"
    />
  </svg>
);
