package maestro.cli.command

import maestro.cli.driver.DriverBuilder
import maestro.cli.driver.RealIOSDeviceDriver
import picocli.CommandLine
import java.util.concurrent.Callable

@CommandLine.Command(
    name = "driver-setup",
    description = [
        "Setup maestro drivers on your devices. Right now works for real iOS devices"
    ]
)
class DriverCommand : Callable<Int> {

    @CommandLine.Option(
        names = ["--apple-team-id"],
        description = ["The Team ID is a unique 10-character string generated by Apple that is assigned to your team's apple account."]
    )
    private var appleTeamId: String? = null

    @CommandLine.Option(
        names = ["--destination"],
        description = ["Destination device to build the driver for. Defaults to generic/platform=iphoneos if not specified."]
    )
    private var destination: String? = null


    override fun call(): Int {
        val teamId = requireNotNull(appleTeamId) { "Apple account team ID must be specified." }
        val destination = destination ?: "generic/platform=iphoneos"

        val driverBuilder = DriverBuilder()

        RealIOSDeviceDriver(
            teamId = teamId,
            destination = destination,
            driverBuilder = driverBuilder,
        ).validateAndUpdateDriver(force = true)

        return 0
    }
}