
// SPDX-License-Identifier: MIT

#ifndef PAX_DEF_BUF_TYPE
    #define PAX_DEF_BUF_TYPE(bpp, name)
#endif

#ifndef PAX_DEF_BUF_TYPE_PAL
    #define PAX_DEF_BUF_TYPE_PAL(bpp, name) PAX_DEF_BUF_TYPE(bpp, name)
#endif

#ifndef PAX_DEF_BUF_TYPE_GREY
    #define PAX_DEF_BUF_TYPE_GREY(bpp, name) PAX_DEF_BUF_TYPE(bpp, name)
#endif

#ifndef PAX_DEF_BUF_TYPE_ARGB
    #define PAX_DEF_BUF_TYPE_ARGB(bpp, a, r, g, b, name) PAX_DEF_BUF_TYPE(a + r + g + b, name)
#endif

#ifndef PAX_DEF_BUF_TYPE_RGB
    #define PAX_DEF_BUF_TYPE_RGB(bpp, r, g, b, name) PAX_DEF_BUF_TYPE_ARGB(bpp, 0, r, g, b, name)
#endif

PAX_DEF_BUF_TYPE_PAL(1, PAX_BUF_1_PAL)
PAX_DEF_BUF_TYPE_PAL(2, PAX_BUF_2_PAL)
PAX_DEF_BUF_TYPE_PAL(4, PAX_BUF_4_PAL)
PAX_DEF_BUF_TYPE_PAL(8, PAX_BUF_8_PAL)
PAX_DEF_BUF_TYPE_PAL(16, PAX_BUF_16_PAL)
PAX_DEF_BUF_TYPE_GREY(1, PAX_BUF_1_GREY)
PAX_DEF_BUF_TYPE_GREY(2, PAX_BUF_2_GREY)
PAX_DEF_BUF_TYPE_GREY(4, PAX_BUF_4_GREY)
PAX_DEF_BUF_TYPE_GREY(8, PAX_BUF_8_GREY)
PAX_DEF_BUF_TYPE_RGB(8, 3, 3, 2, PAX_BUF_8_332RGB)
PAX_DEF_BUF_TYPE_RGB(16, 5, 6, 5, PAX_BUF_16_565RGB)
PAX_DEF_BUF_TYPE_RGB(24, 8, 8, 8, PAX_BUF_24_888RGB)
PAX_DEF_BUF_TYPE_ARGB(4, 1, 1, 1, 1, PAX_BUF_4_1111ARGB)
PAX_DEF_BUF_TYPE_ARGB(8, 2, 2, 2, 2, PAX_BUF_8_2222ARGB)
PAX_DEF_BUF_TYPE_ARGB(16, 4, 4, 4, 4, PAX_BUF_16_4444ARGB)
PAX_DEF_BUF_TYPE_ARGB(32, 8, 8, 8, 8, PAX_BUF_32_8888ARGB)

#undef PAX_DEF_BUF_TYPE
#undef PAX_DEF_BUF_TYPE_PAL
#undef PAX_DEF_BUF_TYPE_GREY
#undef PAX_DEF_BUF_TYPE_ARGB
#undef PAX_DEF_BUF_TYPE_RGB
