import re

from app.translator.core.exceptions.functions import InvalidFunctionSignature, NotSupportedFunctionException
from app.translator.core.functions import PlatformFunctions
from app.translator.core.models.functions.base import ParsedFunctions
from app.translator.platforms.base.spl.functions.const import SplFunctionType
from app.translator.platforms.base.spl.functions.manager import SplFunctionsManager


class SplFunctions(PlatformFunctions):
    manager = SplFunctionsManager()

    @staticmethod
    def prepare_query(query: str) -> str:
        if query.startswith(SplFunctionType.search):
            query = re.sub(SplFunctionType.search, "", query, 1)
        return query

    def parse(self, query: str) -> tuple[str, ParsedFunctions]:
        parsed = []
        not_supported = []
        invalid = []
        functions = query.split(self.function_delimiter)
        result_query = self.prepare_query(functions[0])
        for func in functions[1:]:
            split_func = func.strip().split(" ")
            func_name, func_body = split_func[0], " ".join(split_func[1:])
            if func_parser := self.manager.get_parser(self.manager.get_generic_func_name(func_name)):
                try:
                    parsed.append(func_parser.parse(func_body))
                except NotSupportedFunctionException:
                    not_supported.append(func)
                except InvalidFunctionSignature:
                    invalid.append(func)
            else:
                not_supported.append(func)
        return result_query, ParsedFunctions(
            functions=parsed,
            not_supported=[self.wrap_function_with_delimiter(func) for func in not_supported],
            invalid=invalid,
        )
