from app.translator.core.models.platform_details import PlatformDetails

PLATFORM_DETAILS = {
    "group_id": "opensearch",
    "group_name": "AWS OpenSearch",
    "alt_platform_name": "ECS",
}

OPENSEARCH_LUCENE_QUERY_DETAILS = {
    "siem_type": "opensearch-lucene-query",
    "name": "AWS OpenSearch Query",
    "platform_name": "Query (Lucene)",
    **PLATFORM_DETAILS
}

OPENSEARCH_RULE_DETAILS = {
    "siem_type": "opensearch-lucene-rule",
    "name": "AWS OpenSearch Rule",
    "platform_name": "Rule (JSON)",
    "first_choice": 0,
    **PLATFORM_DETAILS
}

opensearch_query_details = PlatformDetails(**OPENSEARCH_LUCENE_QUERY_DETAILS)
opensearch_rule_details = PlatformDetails(**OPENSEARCH_RULE_DETAILS)


OPENSEARCH_RULE = {
    "type": "monitor",
    "name": "Autogenerated OpenDistro rule",
    "enabled": True,
    "schedule": {
        "period": {
            "interval": 1,
            "unit": "MINUTES"
        }
    },
    "inputs": [
        {
            "search": {
                "indices": [
                    "winlogbeat-*"
                ],
                "query": {
                    "size": 1000,
                    "query": {
                        "bool": {
                            "must": [
                                {
                                    "query_string": {
                                        "query": "",
                                        "analyze_wildcard": True
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        }
    ],
    "triggers": [
        {
            "name": "Trigger: Malicious PowerView PowerShell Commandlets",
            "severity": "4",
            "condition": {
                "script": {
                    "source": "ctx.results[0].hits.total.value > 0",
                    "lang": "painless"
                }
            },
            "actions": [
                {
                    "name": "some alert",
                    "destination_id": "DESTINATION_ID",
                    "message_template": {
                        "source": "",
                        "lang": "mustache"
                    },
                    "throttle_enabled": False,
                    "subject_template": {
                        "source": "",
                        "lang": "mustache"
                    }
                }
            ]
        }
    ]
}