/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pulsar.functions.runtime.process;

import lombok.Data;
import lombok.ToString;
import org.apache.pulsar.common.configuration.FieldContext;

@Data
@ToString
public class ProcessRuntimeFactoryConfig {
    @FieldContext(
        doc = "The path to the java instance. Change the jar location only when you put"
            + " the java instance jar in a different location"
    )
    protected String javaInstanceJarLocation;
    @FieldContext(
        doc = "The path to the python instance. Change the python instance location only"
            + " when you put the python instance in a different location"
    )
    protected String pythonInstanceLocation;
    @FieldContext(
        doc = "The path to the log directory"
    )
    protected String logDirectory;
    @FieldContext(
        doc = "the directory for dropping extra function dependencies"
    )
    protected String extraFunctionDependenciesDir;
}
