---
id: io-connectors
title: Builtin Connectors
sidebar_label: Builtin Connectors
---

Pulsar distribution includes a set of common connectors that have been packaged and tested with the rest of Apache Pulsar.
These connectors import and export data from some of the most commonly used data systems. Using any these connectors is
as easy as writing a simple connector configuration and running the connector locally or submitting the connector to a
Pulsar Functions cluster.

- [Aerospike Sink Connector](io-aerospike.md)
- [Cassandra Sink Connector](io-cassandra.md)
- [Kafka Sink Connector](io-kafka.md#sink)
- [Kafka Source Connector](io-kafka.md#source)
- [Kinesis Sink Connector](io-kinesis.md#sink)
- [RabbitMQ Source Connector](io-rabbitmq.md#source)
- [RabbitMQ Sink Connector](io-rabbitmq.md#sink)
- [Twitter Firehose Source Connector](io-twitter.md)
- [CDC Source Connector based on Debezium](io-cdc.md)
- [Netty Source Connector](io-netty.md#source)
- [Hbase Sink Connector](io-hbase.md#sink)
- [ElasticSearch Sink Connector](io-elasticsearch.md#sink)
- [File Source Connector](io-file.md#source)
- [Hdfs Sink Connector](io-hdfs.md#sink)
- [MongoDB Sink Connector](io-mongo.md#sink)
- [Redis Sink Connector](io-redis.md#sink)
- [Solr Sink Connector](io-solr.md#sink)
- [InfluxDB Sink Connector](io-influxdb.md#sink)
- [JDBC Sink Connector](io-jdbc.md)
