---
id: administration-stats
title: Pulsar stats
sidebar_label: Pulsar statistics
---

## Partitioned topics

|Stat|Description|
|---|---|
|msgRateIn| The sum of all local and replication publishers’ publish rates in messages per second|
|msgThroughputIn| Same as msgRateIn but in bytes per second instead of messages per second|
|msgRateOut|  The sum of all local and replication consumers’ dispatch rates in messages per second|
|msgThroughputOut|  Same as msgRateOut but in bytes per second instead of messages per second|
|averageMsgSize|  Average message size, in bytes, from this publisher within the last interval|
|storageSize| The sum of the ledgers’ storage size for this topic|
|publishers|  The list of all local publishers into the topic. There can be anywhere from zero to thousands.|
|producerId|  Internal identifier for this producer on this topic|
|producerName|  Internal identifier for this producer, generated by the client library|
|address| IP address and source port for the connection of this producer|
|connectedSince|  Timestamp this producer was created or last reconnected|
|subscriptions| The list of all local subscriptions to the topic|
|my-subscription| The name of this subscription (client defined)|
|msgBacklog|  The count of messages in backlog for this subscription|
|type|  This subscription type|
|msgRateExpired|  The rate at which messages were discarded instead of dispatched from this subscription due to TTL|
|consumers| The list of connected consumers for this subscription|
|consumerName|  Internal identifier for this consumer, generated by the client library|
|availablePermits|  The number of messages this consumer has space for in the client library’s listen queue. A value of 0 means the client library’s queue is full and receive() isn’t being called. A nonzero value means this consumer is ready to be dispatched messages.|
|replication| This section gives the stats for cross-colo replication of this topic|
|replicationBacklog|  The outbound replication backlog in messages|
|connected| Whether the outbound replicator is connected|
|replicationDelayInSeconds| How long the oldest message has been waiting to be sent through the connection, if connected is true|
|inboundConnection| The IP and port of the broker in the remote cluster’s publisher connection to this broker|
|inboundConnectedSince| The TCP connection being used to publish messages to the remote cluster. If there are no local publishers connected, this connection is automatically closed after a minute.|


## Topics

|Stat|Description|
|---|---|
|entriesAddedCounter| Messages published since this broker loaded this topic|
|numberOfEntries| Total number of messages being tracked|
|totalSize| Total storage size in bytes of all messages|
|currentLedgerEntries|  Count of messages written to the ledger currently open for writing|
|currentLedgerSize| Size in bytes of messages written to ledger currently open for writing|
|lastLedgerCreatedTimestamp|  Time when last ledger was created|
|lastLedgerCreationFailureTimestamp|  time when last ledger was failed|
|waitingCursorsCount| How many cursors are caught up and waiting for a new message to be published|
|pendingAddEntriesCount|  How many messages have (asynchronous) write requests we are waiting on completion|
|lastConfirmedEntry|  The ledgerid:entryid of the last message successfully written. If the entryid is -1, then the ledger has been opened or is currently being opened but has no entries written yet.|
|state| The state of the cursor ledger. Open means we have a cursor ledger for saving updates of the markDeletePosition.|
|ledgers| The ordered list of all ledgers for this topic holding its messages|
|cursors| The list of all cursors on this topic. There will be one for every subscription you saw in the topic stats.|
|markDeletePosition|  The ack position: the last message the subscriber acknowledged receiving|
|readPosition|  The latest position of subscriber for reading message|
|waitingReadOp| This is true when the subscription has read the latest message published to the topic and is waiting on new messages to be published.|
|pendingReadOps|  The counter for how many outstanding read requests to the BookKeepers we have in progress|
|messagesConsumedCounter| Number of messages this cursor has acked since this broker loaded this topic|
|cursorLedger|  The ledger being used to persistently store the current markDeletePosition|
|cursorLedgerLastEntry| The last entryid used to persistently store the current markDeletePosition|
|individuallyDeletedMessages| If Acks are being done out of order, shows the ranges of messages Acked between the markDeletePosition and the read-position|
|lastLedgerSwitchTimestamp| The last time the cursor ledger was rolled over|
