+++
title = "Bolt Pub/Sub"
description = "A pure Go key/value store"
date = 2021-11-19T00:00:00+02:00
bref = "A pure Go key/value store"
weight = -10
type = "docs"
toc = false
+++

### Bolt Pub/Sub

Bolt is a pure Go key/value store which provides a simple, fast, and reliable
database for projects that don't require a full database server such as
Postgres or MySQL.

Bolt backed Pub/Sub is good for simple applications which don't need a more
advanced Pub/Sub system with external dependencies or already use Bolt and
want to publish messages in transaction when saving other data.

Bolt documentation: https://github.com/etcd-io/bbolt

### Installation

    go get github.com/ThreeDotsLabs/watermill-bolt

#### Characteristics

| Feature             | Implements | Note |
| ------------------- | ---------- | ---- |
| ConsumerGroups      | no         |      |
| ExactlyOnceDelivery | no         |      |
| GuaranteedOrder     | no         |      |
| Persistent          | yes        |      |

#### Configuration

{{% render-md %}}
{{% load-snippet-partial file="src-link/watermill-bolt/pkg/bolt/bolt.go" first_line_contains="type CommonConfig struct " last_line_equals="}" %}}
{{% /render-md %}}

{{% render-md %}}
{{% load-snippet-partial file="src-link/watermill-bolt/pkg/bolt/bolt.go" first_line_contains="type PublisherConfig struct " last_line_equals="}" %}}
{{% /render-md %}}

{{% render-md %}}
{{% load-snippet-partial file="src-link/watermill-bolt/pkg/bolt/bolt.go" first_line_contains="type SubscriberConfig struct " last_line_equals="}" %}}
{{% /render-md %}}

##### Subscription name

To receive messages published to a topic, you must create a subscription to
that topic. Only messages published to the topic after the subscription is
created will be received by the subscriber.

A topic can have multiple subscriptions, but a given subscription belongs to
a single topic.

In Watermill, the subscription is created automatically during calling
`Subscribe()`.  Subscription name is generated by calling the function set as
`SubscriberConfig.GenerateSubscriptionName`.  By default, it is the topic name
with the string `_sub` appended to it.

##### Marshaler

Watermill's messages cannot be directly saved in Bolt which operates on byte
slices. Marshaller converts the messages to and from byte slices. The default
implementation marshals messages as JSON, a format which is human-readable
for easier debugging. The performance should be enough for most applications
unless a very large messages are used within your system. If that is the case
you may want to consider implementing a more efficient marshaler.

{{% render-md %}}
{{% load-snippet-partial file="src-link/watermill-bolt/pkg/bolt/marshaler.go" first_line_contains="// Marshaler" last_line_equals="}" %}}
{{% /render-md %}}


