+++
title = "Awesome Watermill"
description = "Selected unofficial libraries"
weight = 0
draft = false
toc = true
bref = "Selected unofficial libraries"
type = "docs"
+++

Below is a list of libraries that are not maintained by Three Dots Labs, but you may find them useful.

**Please note we can't provide support or guarantee they work correctly**. Do your own research.

If you know another library or are an author of one, please [add it to the list](https://github.com/ThreeDotsLabs/watermill/edit/master/docs/content/docs/awesome.md).

### Examples

* https://github.com/minghsu0107/golang-taipei-watermill-example
* https://github.com/minghsu0107/Kafka-PubSub
* https://github.com/pperaltaisern/go-example-financing

### Pub/Subs

* Apache Pulsar https://github.com/AlexCuse/watermill-pulsar
* Apache RocketMQ https://github.com/yflau/watermill-rocketmq
* CockroachDB https://github.com/cockroachdb/watermill-crdb
* Ensign https://github.com/rotationalio/watermill-ensign
* GoogleCloud Pub/Sub HTTP Push https://github.com/dentech-floss/watermill-googlecloud-http
* MongoDB https://github.com/cunyat/watermill-mongodb
* MQTT https://github.com/perfect13/watermill-mqtt
* NSQ https://github.com/chennqqi/watermill-nsq

### Logging

* logrus
  * https://github.com/ma-hartma/watermill-logrus-adapter
  * https://github.com/UNIwise/walrus
* logur https://github.com/logur/integration-watermill
* zap
  * https://github.com/garsue/watermillzap
  * https://github.com/pperaltaisern/watermillzap
* zerolog
  * https://github.com/alexdrl/zerowater
  * https://github.com/bogatyr285/watermillzlog
  * https://github.com/vsvp21/zerolog-watermill-adapter

### Observability

* OpenCensus
  * https://github.com/czeslavo/watermill-opencensus
  * https://github.com/sagikazarmark/ocwatermill
* OpenTelemetry
  * https://github.com/voi-oss/watermill-opentelemetry
  * https://github.com/dentech-floss/watermill-opentelemetry-go-extra
  * AMQP https://github.com/hpcslag/otel-watermill-amqp
  * GoChannel https://github.com/hpcslag/watermill-otel-tracable-gochannel

### Other

* https://github.com/asyncapi/go-watermill-template
* https://github.com/goph/watermillx
* https://github.com/voi-oss/protoc-gen-event
