/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package org.elasticsearch.action;

import org.elasticsearch.common.io.stream.StreamInput;

import java.io.IOException;

public class NoSuchNodeException extends FailedNodeException {

    public NoSuchNodeException(String nodeId) {
        super(nodeId, "No such node [" + nodeId + "]", null);
    }

    public NoSuchNodeException(StreamInput in) throws IOException {
        super(in);
    }
}
