/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package org.elasticsearch.painless.node;

import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.phase.UserTreeVisitor;

/**
 * Represents a return statement.
 */
public class SReturn extends AStatement {

    private final AExpression valueNode;

    public SReturn(int identifier, Location location, AExpression valueNode) {
        super(identifier, location);

        this.valueNode = valueNode;
    }

    public AExpression getValueNode() {
        return valueNode;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitReturn(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        if (valueNode != null) {
            valueNode.visit(userTreeVisitor, scope);
        }
    }
}
