/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package org.elasticsearch.search;

import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.test.ESTestCase;

import static org.mockito.Mockito.mock;

public class MockSearchServiceTests extends ESTestCase {

    public void testAssertNoInFlightContext() {
        ReaderContext reader = mock(ReaderContext.class);
        MockSearchService.addActiveContext(reader);
        try {
            Throwable e = expectThrows(AssertionError.class, () -> MockSearchService.assertNoInFlightContext());
            assertEquals(
                "There are still [1] in-flight contexts. The first one's creation site is listed as the cause of this exception.",
                e.getMessage()
            );
            e = e.getCause();
            assertEquals(MockSearchService.class.getName(), e.getStackTrace()[0].getClassName());
            assertEquals(MockSearchServiceTests.class.getName(), e.getStackTrace()[1].getClassName());
        } finally {
            MockSearchService.removeActiveContext(reader);
        }
    }
}
