/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package org.elasticsearch.index.analysis;

import org.elasticsearch.indices.analysis.AnalysisFactoryTestCase;
import org.elasticsearch.plugin.analysis.icu.AnalysisICUPlugin;

import java.util.HashMap;
import java.util.Map;

public class AnalysisICUFactoryTests extends AnalysisFactoryTestCase {
    public AnalysisICUFactoryTests() {
        super(new AnalysisICUPlugin());
    }

    @Override
    protected Map<String, Class<?>> getTokenizers() {
        Map<String, Class<?>> tokenizers = new HashMap<>(super.getTokenizers());
        tokenizers.put("icu", IcuTokenizerFactory.class);
        return tokenizers;
    }

    @Override
    protected Map<String, Class<?>> getTokenFilters() {
        Map<String, Class<?>> filters = new HashMap<>(super.getTokenFilters());
        filters.put("icufolding", IcuFoldingTokenFilterFactory.class);
        filters.put("icunormalizer2", IcuNormalizerTokenFilterFactory.class);
        filters.put("icutransform", IcuTransformTokenFilterFactory.class);
        return filters;
    }

    @Override
    protected Map<String, Class<?>> getCharFilters() {
        Map<String, Class<?>> filters = new HashMap<>(super.getCharFilters());
        filters.put("icunormalizer2", IcuNormalizerCharFilterFactory.class);
        return filters;
    }

}
