/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
package org.elasticsearch.client.ml.job.process;

import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.xcontent.XContentParser;
import org.joda.time.DateTime;

import java.time.Instant;

public class DataCountsTests extends AbstractXContentTestCase<DataCounts> {

    public static DataCounts createTestInstance(String jobId) {
        return new DataCounts(
            jobId,
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            randomIntBetween(1, 1_000_000),
            new DateTime(randomDateTimeZone()).toDate(),
            new DateTime(randomDateTimeZone()).toDate(),
            new DateTime(randomDateTimeZone()).toDate(),
            new DateTime(randomDateTimeZone()).toDate(),
            new DateTime(randomDateTimeZone()).toDate(),
            randomBoolean() ? null : Instant.now()
        );
    }

    @Override
    public DataCounts createTestInstance() {
        return createTestInstance(randomAlphaOfLength(10));
    }

    @Override
    protected DataCounts doParseInstance(XContentParser parser) {
        return DataCounts.PARSER.apply(parser, null);
    }

    @Override
    protected boolean supportsUnknownFields() {
        return true;
    }

}
